<?php
/**
 * -----------------------------------------
 * @author Nico Schubert / www.php-space.info
 * @copyright Das Script kann unter Verwendung des Copyright uneingeschränkt genutzt / verändert werden. Das Copyright muss im Code sowie in der Ausgabe erhalten bleiben.
 * @version Datei Upload Version 1.12 12.12.2022
 * @abstract Das Script läuft erst ab der Php Version 8.1 oder höher, wenn Sie Thumbnail erstellen wollen, benötigen Sie GD Bibliothek in der Version 2.0.1 oder höher. Wenn Sie Probleme mit dem Einrichten haben, so schauen Sie bitte in die Anleitung-> Installationsanleitung_1.12.pdf
 * -----------------------------------------
 */

use JetBrains\PhpStorm\NoReturn;

if (strpos("functions.php", $_SERVER["PHP_SELF"])) {
  exit;
}
/**
 * @param string $datei
 * @param int $nachkommastellen
 * @return string
 */
function fs_convert(string $datei, int $nachkommastellen = 0): string
{
  $size = @filesize($datei);
  if ($size >= 1073741824) {
    return round($size / (1073741824), $nachkommastellen) . " GB";
  }

  if ($size >= 1048576) {
    return round($size / (1048576), $nachkommastellen) . " MB";
  }

  if ($size >= 1024) {
    return round($size / (1024), $nachkommastellen) . " KB";
  }
  return $size . " Byte";
}

/**
 * @param string $site
 * @return int
 */
function last_change(string $site): int
{
  if (empty($site)) {
    $site = $_SERVER['DOCUMENT_ROOT'];
    $site .= $_SERVER['PHP_SELF'];
  }
  return filemtime($site);
}

/**
 * @return bool
 */
function uploadmoeglichkeitpruefen()
{
  $uploadmoeglichkeit = true;
  if (strtolower(@ini_get('file_uploads')) == 'off' || @ini_get('file_uploads') == 0) {
    $uploadmoeglichkeit = false;
  }
  return $uploadmoeglichkeit;
}

/**
 * @return int
 */
function maximaledateiuploadgroesseermitteln(): int
{
  $maximaledateiuploadgroesse = 0;
  if ($dateigroesse = ini_get('upload_max_filesize')) {

    $maximaledateiuploadgroesse = phpiniwertumwandeln($dateigroesse);
  }
  if ($postgroesse = ini_get('post_max_size')) {
    $postgroesse = phpiniwertumwandeln($postgroesse);
    if ($postgroesse < $maximaledateiuploadgroesse) {
      $maximaledateiuploadgroesse = $postgroesse;
    }
  }
  return $maximaledateiuploadgroesse;
}

/**
 * @param string $groesse
 * @return int
 */
function phpiniwertumwandeln(string $groesse): int
{
  $werte['MB'] = 1048576;
  $werte['Mb'] = 1048576;
  $werte['M'] = 1048576;
  $werte['m'] = 1048576;
  $werte['KB'] = 1024;
  $werte['Kb'] = 1024;
  $werte['K'] = 1024;
  $werte['k'] = 1024;

  foreach ($werte as $schluessel => $value) {
    if ((strlen($groesse) > strlen($schluessel)) && (substr($groesse, strlen($groesse) - strlen($schluessel)) == $schluessel)) {
      $groesse = substr($groesse, 0, strlen($groesse) - strlen($schluessel)) * $value;
      break;
    }
  }
  return $groesse;
}

/**
 * @param string $bild
 * @param string $bilder_path_orginalbild
 * @param string $bilder_path_thumbnail
 * @param int $thumbnail_neuebreite
 * @return mixed
 */
function thumbnail(string $bild = '', string $bilder_path_orginalbild = '', string $bilder_path_thumbnail = '', int $thumbnail_neuebreite = 0): mixed
{
  global $lang;
  $size = getimagesize($bilder_path_orginalbild . $bild) or die($lang['file_groesse']);
  $breite = $size[0];
  $hoehe = $size[1];
  $neuebreite = $thumbnail_neuebreite;
  $neuehoehe = intval($hoehe * $neuebreite / $breite);

  if ($size[2] == 1) {
    // GIF
    $altesbild = imagecreatefromgif($bilder_path_orginalbild . $bild);
    $neuesbild = imagecreatetruecolor($neuebreite, $neuehoehe);
    imagecopyresized($neuesbild, $altesbild, 0, 0, 0, 0, $neuebreite, $neuehoehe, $breite, $hoehe);
    imagegif($neuesbild, $bilder_path_thumbnail . "TN" . $bild);
  }

  if ($size[2] == 2) {
    // JPG
    $altesbild = imagecreatefromjpeg($bilder_path_orginalbild . $bild);
    $neuesbild = imagecreatetruecolor($neuebreite, $neuehoehe);
    imagecopyresized($neuesbild, $altesbild, 0, 0, 0, 0, $neuebreite, $neuehoehe, $breite, $hoehe);
    imagejpeg($neuesbild, $bilder_path_thumbnail . "TN" . $bild);
  }

  if ($size[2] == 3) {
    // PNG
    $altesbild = imagecreatefrompng($bilder_path_orginalbild . $bild);
    $neuesbild = imagecreatetruecolor($neuebreite, $neuehoehe);
    imagecopyresized($neuesbild, $altesbild, 0, 0, 0, 0, $neuebreite, $neuehoehe, $breite, $hoehe);
    imagepng($neuesbild, $bilder_path_thumbnail . "TN" . $bild);
  }
  return $size[2];
}


/**
 * @param array $lang
 * @param string $ausgabe
 * @param string $type
 * @param string $navigation_elements_back
 */
#[NoReturn] function error_back(array $lang, string $ausgabe, string $type, string $navigation_elements_back = 'navigationselemente_zurueck'): void
{
  $ausgabe .= '<div class="error">' . $lang[$type] . ' <a href="' . htmlspecialchars($_SERVER['PHP_SELF']) . '">' . $lang[$navigation_elements_back] . '</a><br><br></div>' . "\n";
  include_once('footer.php');
  exit;
}

/**
 * @param array $lang
 * @param string $ausgabe
 * @return void
 */
#[NoReturn] function show_successfully(array $lang, string $ausgabe): void
{
  $ausgabe .= '<div class="successfully">' . $lang['file_delete_true'] . ' <a href="' . htmlspecialchars($_SERVER['PHP_SELF']) . '">' . $lang['navigationselemente_zurueck'] . '</a><br><br></div>' . "\n";
  include_once('footer.php');
  exit;
}

/**
 * @param int $page
 * @param array $verzeichnis_daten
 * @param string $ausgabe
 * @param int $length
 * @return string
 */
function show_navigation(int $page, array $verzeichnis_daten, string $ausgabe, int $length): string
{
  if ($page > 0 and count($verzeichnis_daten) != 0) {
    $ausgabe .= '<a href="' . htmlspecialchars($_SERVER['PHP_SELF']) . '?page=' . ($page - 1) . '">&laquo;</a> ' . "\n";
  }
  if ((count($verzeichnis_daten) / $length) > ($page + 1) and count($verzeichnis_daten) != 0) {
    $ausgabe .= '<a href="' . htmlspecialchars($_SERVER['PHP_SELF']) . '?page=' . ($page + 1) . '">&raquo;</a> ' . "\n";
  }
  return $ausgabe;
}

/**
 * @param string $ausgabe
 * @param array $lang
 * @return string
 */
function show_no_file(string $ausgabe, array $lang): string
{
  $ausgabe .= '<tr class="bgcolor">' . "\n";
  $ausgabe .= '	<td colspan="4">' . $lang['file_list_no_file'] . '</td>' . "\n";
  $ausgabe .= '</tr>' . "\n";
  return $ausgabe;
}