<?php
/**
 * -----------------------------------------
 * @author Nico Schubert / www.php-space.info
 * @copyright Das Script kann unter Verwendung des Copyright uneingeschränkt genutzt / verändert werden. Das Copyright muss im Code sowie in der Ausgabe erhalten bleiben.
 * @version Datei Upload Version 1.12 12.12.2022
 * @abstract Das Script läuft erst ab der Php Version 8.1 oder höher, wenn Sie Thumbnail erstellen wollen, benötigen Sie GD Bibliothek in der Version 2.0.1 oder höher. Wenn Sie Probleme mit dem Einrichten haben, so schauen Sie bitte in die Anleitung -> Installationsanleitung_1.12.pdf
 * -----------------------------------------
 */
if (strpos("processing.php", $_SERVER["PHP_SELF"])) {
    exit;
}
$filename = '';
if ($_POST["senden"] == 1) {
    $ausgabe .= '<br>' . "\n";
    $ausgabe .= '    <strong>' . $lang['navigationselemente_ueberscrift_file_upload'] . '</strong><br><br>' . "\n";
    if ($_FILES['userfile']['tmp_name'] == '') {
        error_back($lang, $ausgabe, 'file_auswaehlen', 'navigationselemente_nochmal');
    }
    if ($_FILES['userfile']['tmp_name'] <> 'none' OR $_FILES['userfile']['tmp_name'] != '') {
        $file = $_FILES['userfile']['name'];
        $temp = $_FILES['userfile']['tmp_name'];
        if (preg_match("!\.php!", $file) == true) {
            error_back($lang, $ausgabe, (($upload_erlaubnis != 0) ? 'file_img' : 'file_d'), 'navigationselemente_nochmal');
        }
        $path_parts = @pathinfo($file);
        if (!isset($path_parts["extension"])) $path_parts["extension"] = '';
        if(!isset($dateityp_einschraenkung_img)) $dateityp_einschraenkung_img=array();
        if ($upload_erlaubnis == 1) {
            if (is_array($dateityp_einschraenkung_img) == true) {
                foreach ($dateityp_einschraenkung_img as $k => $v) {
                    if ($_FILES['userfile']['type'] == trim($v)) {
                        $ist_bild = 1;
                        break;
                    }
                }
            }
            if (function_exists("exif_imagetype") == true) {
                if (exif_imagetype($temp) == (IMAGETYPE_GIF OR IMAGETYPE_JPEG OR IMAGETYPE_PNG)) $ist_bild = 1; else $ist_bild = 0;
            }
        }
        /**
         * TODO: http://de3.php.net/finfo_file
         */
        if ($upload_erlaubnis == 0) {
            if (is_array($dateityp_einschraenkung) == true) {
                foreach ($dateityp_einschraenkung as $k => $v) {
                    if ($_FILES['userfile']['type'] == trim($v)) {
                        $ist_bild = 1;
                        break;
                    }
                }
            } else {
                $ist_bild = 0;
            }
        }
        if ($ist_bild == 0) {
            error_back($lang, $ausgabe, (($upload_erlaubnis != 0) ? 'file_img' : 'file_d'), 'navigationselemente_nochmal');
        } else {
            if ($path_parts["extension"] != "") {
                if ($dateiname_dynamisch == 1) {
                    $filename = "datei_" . time() . "." . $path_parts["extension"];
                } else {
                    $filename = $file;
                    $umlaute = array(
                        'ä' => 'ae',
                        'Ä' => 'ae',
                        'ß' => 'ss',
                        'ö' => 'oe',
                        'Ö' => 'oe',
                        'Ü' => 'ue',
                        'ü' => 'ue',
                        ' ' => '-',
                        'â' => 'a',
                        'Â' => 'a',
                        'ê' => 'e',
                        'Ê' => 'e'
                    );
                    $filename = str_replace(array_keys($umlaute), array_values($umlaute), $filename);
                    if (preg_match($reg_exp, $filename) == false) {
                        error_back($lang, $ausgabe, 'file_name', 'navigationselemente_nochmal');

                    }
                }
                if ($_FILES['userfile']['size'] <= $groessemax * 1024) {
                    if (decoct(fileperms($document_root . $img_ordner)) == 40777) {
                        if (@copy($temp, $document_root . $img_ordner . $filename)) {
                            chmod($document_root . $img_ordner . $filename, 0755);
                            $ausgabe .= '<div style="color:green;">' . $lang['file_true'] . '<br>';
                            $ausgabe .= 'Url der Datei: <a href="' . htmlspecialchars($url . $img_ordner . $filename) . '" target="_blank">' . htmlspecialchars($url . $img_ordner . $filename) . '</a><br><br><a href="' . htmlspecialchars($_SERVER['PHP_SELF']) . '">' . $lang['navigationselemente_noch_eine_datei'] . '</a><br><br></div>' . "\n";
                            include_once('footer.php');
                            exit;
                        } else {
                            error_back($lang, $ausgabe, 'fehler_upload', 'navigationselemente_nochmal');
                        }
                    } else {
                        error_back($lang, $ausgabe, 'fehler_upload_rechte', 'navigationselemente_nochmal');
                    }
                } else {
                    $lang['fehler_upload_groesse'] = str_replace("~groesse~", $groessemax, $lang['fehler_upload_groesse']);
                    error_back($lang, $ausgabe, 'fehler_upload_groesse', 'navigationselemente_nochmal');
                }
            }
        }
    }
}